#ifndef __EffectsManager_h__
#define __EffectsManager_h__

#include <lib3d/util2d/Particle.h>

#include <list>
using namespace std;

#define MAX_EMITTER_COUNT 500

struct tExpDecal {
   float x,y;
   float life_scale;
   float remaining_life;
};

struct tBloodSplat {
   float x,y;
   float life_scale;
   float remaining_life;
   float rot;
};

struct tEmitter {   
public:
   ~tEmitter() { delete emitter; };
   int eid;
   bool active;      // update and render if true
   bool killme;      // delete emitter if true
   bool timed;
   float timeout;
   Particle *emitter;
};

struct tExplosion {
   float x,y;
   Texture *tex;
   float time;
};

typedef list<Texture*>   TextureList;
typedef list<tExplosion> ExplosionList;
typedef list<tExpDecal>  DecalList;
typedef list<tBloodSplat>  BloodList;

class EffectsManager {

public:
   void init();
   void makeExplosion(float x,float y);
   void makePlayerExplosion(int pid);
   void createExplosionDecal(float x,float y,float life_scale);
   void createBloodSplat(float x,float y,float life_scale);
   int  createMissileTrail(float x,float y);
   void removeEmitter(int eid);
   void removeEmitterByTime(int eid,float timeout);
   void setEmitterPos(int eid,float x,float y);
   void setPlayerDamageEffect(int pid,int level);
   void reset();

   void updatePlayerPositions(float p1x,float p1y,float p2x,float p2y);
   void update(float dt);
   void render();

   static EffectsManager* instance();

protected:
   
   void initTextures();
   void createPlayerDamageEmitters();
   void createPlayerExplosionEmitters();
   int  getFirstFreeEmitter();
      
   DecalList expDecals;
   BloodList bloodSplats;
   ExplosionList explosions;
   TextureList freeExpTextures;
   tEmitter  emitters[MAX_EMITTER_COUNT];
   bool      emitterUsed[MAX_EMITTER_COUNT];
   Particle *missileTrailTemplate;

   Texture *expDecalTex;
   Texture *bloodSplatTex;
   Texture *yellowSmokeTex;
   Texture *explosionShader;
   Texture *pexpTex;

   int peid[2];        // emitter ids for damage particle systems
   int pexeid[2];      // emitter ids for explosion particle systems

   float px[2],py[2];

private:
   EffectsManager();
   ~EffectsManager();

};


#endif